<?php
// create connection to database
$host = "webdev.iyaserver.com"; // database server address
$userid = "dent_student"; // database user account name
$userpw = "code4Studentuse"; // database user password
$db = "dent_health"; // database name

$mysql = new mysqli(
    $host,
    $userid,
    $userpw,
    $db);

if($mysql->connect_errno) {
    echo "db connection error : " . $mysql->connect_error;
    exit();
}
?>

<!-- these php blocks do not need to be separated, but might as well since in many pages with
    full/normal html likely this block would be lower down in the code -->

<?php

/* php variable notes:
    -  php variables have dollar signs in front of their names, like $filter
    - php variables passed through page url strings are named $_REQUEST["variablename"]
    - if a $_REQUEST variable does not exist it does NOT error, it just returns blank
*/

// going to write some php variable and $_REQUEST code here

if(!empty($_REQUEST["condition"])){
    $filter = $_REQUEST["condition"]; 
}
else{
    $filter = 'Asthma'; 
}
// base query
$sql =  "     SELECT 
	                AVG(Age) AS AverageAge,
	                MIN(Age) AS LowAge,
	                MAX(Age) AS HighAge,
	                COUNT(Name) AS NumberPatients
	              FROM healthcare_dataset
	              WHERE MedicalCondition='$filter'
	";

$results = $mysql->query($sql);

if(!$results) {
    echo "SQL error: ". $mysql->error . " running query <hr>" . $sql . "<hr>";
    exit();
}

// since only query in the page, and just a single line query (one row) that
// does not need a loop, pre-load the query columns into $currentrow
$currentrow = $results->fetch_assoc();

// dump columns into source code of page to debug / see column names and data
echo "<!--<pre> ";
var_dump($currentrow);
echo "</pre>-->";
?>



<!-- this is a javascript block in the page... NOT php ... but that doesn't mean we
    can't choose to output/inject content into it with php -->

<!-- javascript block. setting up variables -->
<script>
    // Note that javascript (and jQuery) variables have no symbol in front of the variable name
    var condition = "<?=$filter?>";
    var patients = <?= $currentrow["NumberPatients"] ?>;
    var highage = <?= $currentrow["HighAge"] ?>;
    var lowage = <?= $currentrow["LowAge"] ?>;//You can only output, inherently an echo block
    var avgage = <?= round($currentrow["AverageAge"],1) ?>;
</script>

<style>
    .box { width: 30px; height: 15px; border: 1px solid teal;}
    .box2 { width: 100px; height:15px; border: 1px solid teal; }
	.box, .box2 {
	    position:absolute;
	}
	#chart { width:400px; height:225px; position:relative;
        background-image: url(http://iyawebdev.com/acad274/lecture_examples/healthscreen.png)}
    #condition {
        left: 141px; top:60px; font-size: 14pt;
    }
    #patients { left: 199px; top:92px; font-size: 10pt;}
    #avgage { left: 145px; top:122px; font-size: 10pt;}
    #lowage { left: 143px; top:152px; font-size: 10pt;}
    #highage { left: 145px; top:182px; font-size: 10pt;}
    
</style>
<div id="chart">
    <div class="box2" id="condition"></div>
    <div class="box" id="patients"></div>
    <div class="box" id="avgage"></div>
    <div class="box" id="lowage"></div>
    <div class="box" id="highage"></div>
</div>



<script src="https://code.jquery.com/jquery-3.7.1.js"
integrity="sha256-eKhayi8LEQwp4NKxN+CfCh+3qOVUtJn3QNZ0TciWLP4="
crossorigin="anonymous"></script>
<script><!-- jQuery block -->
$(document).ready(function(){
    // jQuery code
    // output in alert value of avgage variable
    //alert( "avgage =" +  avgage );

    //Take the java variables and plug them into html using jquery
    // write variables to div boxes (by id)
     $("#condition").text(condition);
    $("#patients").text(patients);
    $("#highage").text(highage);
    $("#lowage").text(lowage);
    $("#avgage").text(avgage);

    // then go back to php, and put output php values in place of 0s

});
</script>



